Attribute VB_Name = "Moduicontrol"
Public Sub UpdateAutoSaveUI(ByVal enabled As Boolean)
    On Error Resume Next

    Dim captionText As String
    Dim backColor As Long

    If enabled Then
        captionText = "Receive Auto Save ON"
        backColor = vbGreen
    Else
        captionText = "Receive Auto Save OFF"
        backColor = ltOrange
    End If

    ' Update inboxform controls if loaded
    If IsFormLoaded("inboxform") Then
        With inboxform.chkAutoSave
            .Value = IIf(enabled, vbChecked, vbUnchecked)
            .Caption = captionText
            .backColor = backColor
        End With
        With inboxform.cmdAutoSaveToggle
            .Caption = captionText
            .backColor = backColor
        End With
    End If

    ' Update mainmenu controls if loaded
    If IsFormLoaded("mainmenu") Then
        With mainmenu.chkAutoSave
            .Value = IIf(enabled, vbChecked, vbUnchecked)
            .Caption = captionText
            .backColor = backColor
        End With
        With mainmenu.cmdAutoSaveToggle
            .Caption = captionText
            .backColor = backColor
        End With
    End If
End Sub

Public Function IsFormLoaded(ByVal formName As String) As Boolean
    Dim frm As Form
    For Each frm In Forms
        If frm.Name = formName Then
            IsFormLoaded = True
            Exit Function
        End If
    Next
    IsFormLoaded = False
End Function
